package ru.yandex.ohio.backend;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class TerminalsInfos {
    private final Map<Long, List<TerminalInfo>> terminalsInfos =
        new HashMap<>();
    private final Set<Long> servicesWhitelist;

    public TerminalsInfos(
        final Set<Long> servicesWhitelist,
        final BufferedReader reader)
        throws IOException, JsonException
    {
        this.servicesWhitelist = servicesWhitelist;
        while (true) {
            String line = reader.readLine();
            if (line == null) {
                break;
            }
            JsonObject json = TypesafeValueContentHandler.parse(line);
            TerminalInfo info = new TerminalInfo(json);
            long serviceId = info.serviceId();
            if (serviceId != -1L) {
                if (!servicesWhitelist.contains(serviceId)) {
                    continue;
                }
            }
            terminalsInfos.computeIfAbsent(
                info.terminalId(),
                x -> new ArrayList<>())
                .add(info);
        }
    }

    @Nullable
    public TerminalInfo getTerminalInfo(
        final long terminalId,
        final long serviceId)
    {
        List<TerminalInfo> terminalInfos = terminalsInfos.get(terminalId);
        if (terminalInfos == null) {
            return null;
        }

        TerminalInfo nullServiceInfo = null;
        int size = terminalInfos.size();
        for (int i = 0; i < size; ++i) {
            TerminalInfo info = terminalInfos.get(i);
            long terminalServiceId = info.serviceId();
            if (terminalServiceId == serviceId) {
                return info;
            } else if (terminalServiceId == -1L) {
                nullServiceInfo = info;
            }
        }
        return nullServiceInfo;
    }

    public boolean isKnownService(final long serviceId) {
        return servicesWhitelist.contains(serviceId);
    }

    public Set<Long> servicesWhitelist() {
        return servicesWhitelist;
    }
}

