package ru.yandex.ohio.backend;

import java.io.BufferedReader;
import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.function.CharArrayReaderFactory;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.AsyncCharArrayProcessableConsumer;
import ru.yandex.json.parser.JsonException;

public class UpdateTerminalsInfosHandler
    implements HttpAsyncRequestHandler<CharArrayProcessable>
{
    private final OhioBackend server;

    public UpdateTerminalsInfosHandler(final OhioBackend server) {
        this.server = server;
    }

    @Override
    public AsyncCharArrayProcessableConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new AsyncCharArrayProcessableConsumer();
    }

    @Override
    public void handle(
        final CharArrayProcessable request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        try {
            server.updateTerminalsInfos(
                new BufferedReader(
                    request.processWith(CharArrayReaderFactory.INSTANCE)));
        } catch (IOException | JsonException e) {
            throw new ServiceUnavailableException(e);
        }
        exchange.getResponse().setStatusCode(HttpStatus.SC_OK);
        exchange.submitResponse();
    }
}

