package ru.yandex.ohio.backend;

public class YandexPlusPricePostprocessor implements PricePostprocessor {
    private final double factor;

    public YandexPlusPricePostprocessor(final String currency) {
        if ("BYN".equals(currency)) {
            factor = 10d;
        } else {
            factor = 1d;
        }
    }

    @Override
    public double roundPrice(final double price) {
        return Math.floor(price * factor) / factor;
    }

    @Override
    public boolean skipZeroPrice() {
        return true;
    }
}

