package ru.yandex.ohio.backend.config;

import java.net.URI;
import java.nio.file.Path;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractOhioBackendConfigBuilder
    <T extends AbstractOhioBackendConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements OhioBackendConfig
{
    private Path terminalsInfosPath;
    private HttpHostConfigBuilder producerStoreConfig;
    private HttpHostConfigBuilder darkspiritConfig;
    private URI checkUrlBase;
    private HttpHostConfigBuilder fiscalStoragesConfig;
    private HttpHostConfigBuilder dyngoConfig;
    private HttpHostConfigBuilder fnslinkerConfig;

    protected AbstractOhioBackendConfigBuilder(
        final OhioBackendConfig config)
    {
        super(config);
        terminalsInfosPath(config.terminalsInfosPath());
        producerStoreConfig(config.producerStoreConfig());
        darkspiritConfig(config.darkspiritConfig());
        checkUrlBase(config.checkUrlBase());
        fiscalStoragesConfig(config.fiscalStoragesConfig());
        dyngoConfig(config.dyngoConfig());
        fnslinkerConfig(config.fnslinkerConfig());
    }

    protected AbstractOhioBackendConfigBuilder(
        final IniConfig config,
        final OhioBackendConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        terminalsInfosPath = TERMINALS_INFOS_PATH.extract(
            config,
            defaults.terminalsInfosPath());
        producerStoreConfig = PRODUCER_STORE_CONFIG.extract(
            config,
            defaults.producerStoreConfig());
        darkspiritConfig =
            DARKSPIRIT_CONFIG.extract(config, defaults.darkspiritConfig());
        checkUrlBase = CHECK_URL_BASE.extract(config, defaults.checkUrlBase());
        fiscalStoragesConfig = FISCAL_STORAGES_CONFIG.extract(
            config,
            defaults.fiscalStoragesConfig());
        dyngoConfig = DYNGO_CONFIG.extract(config, defaults.dyngoConfig());
        fnslinkerConfig =
            FNSLINKER_CONFIG.extract(config, defaults.fnslinkerConfig());
    }

    @Override
    public Path terminalsInfosPath() {
        return terminalsInfosPath;
    }

    public T terminalsInfosPath(final Path terminalsInfosPath) {
        this.terminalsInfosPath = terminalsInfosPath;
        return self();
    }

    @Override
    public HttpHostConfigBuilder producerStoreConfig() {
        return producerStoreConfig;
    }

    public T producerStoreConfig(final HttpHostConfig producerStoreConfig) {
        this.producerStoreConfig =
            new HttpHostConfigBuilder(producerStoreConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder darkspiritConfig() {
        return darkspiritConfig;
    }

    public T darkspiritConfig(final HttpHostConfig darkspiritConfig) {
        this.darkspiritConfig = new HttpHostConfigBuilder(darkspiritConfig);
        return self();
    }

    @Override
    public URI checkUrlBase() {
        return checkUrlBase;
    }

    public T checkUrlBase(final URI checkUrlBase) {
        this.checkUrlBase = checkUrlBase;
        return self();
    }

    @Override
    public HttpHostConfigBuilder fiscalStoragesConfig() {
        return fiscalStoragesConfig;
    }

    public T fiscalStoragesConfig(
        final HttpHostConfig fiscalStoragesConfig)
    {
        this.fiscalStoragesConfig =
            new HttpHostConfigBuilder(fiscalStoragesConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder dyngoConfig() {
        return dyngoConfig;
    }

    public T dyngoConfig(final HttpHostConfig dyngoConfig) {
        this.dyngoConfig = new HttpHostConfigBuilder(dyngoConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder fnslinkerConfig() {
        return fnslinkerConfig;
    }

    public T fnslinkerConfig(final HttpHostConfig fnslinkerConfig) {
        this.fnslinkerConfig = new HttpHostConfigBuilder(fnslinkerConfig);
        return self();
    }
}

