package ru.yandex.ohio.backend.config;

import java.net.URI;
import java.nio.file.Path;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableOhioBackendConfig
    extends ImmutableUniversalSearchProxyConfig
    implements OhioBackendConfig
{
    private final Path terminalsInfosPath;
    private final ImmutableHttpHostConfig producerStoreConfig;
    private final ImmutableHttpHostConfig darkspiritConfig;
    private final URI checkUrlBase;
    private final String checkUrlBaseString;
    private final ImmutableHttpHostConfig fiscalStoragesConfig;
    private final ImmutableHttpHostConfig dyngoConfig;
    private final ImmutableHttpHostConfig fnslinkerConfig;

    public ImmutableOhioBackendConfig(final OhioBackendConfig config)
        throws ConfigException
    {
        super(config);
        terminalsInfosPath =
            TERMINALS_INFOS_PATH.validate(config.terminalsInfosPath());
        producerStoreConfig =
            PRODUCER_STORE_CONFIG.validate(config.producerStoreConfig());
        darkspiritConfig =
            DARKSPIRIT_CONFIG.validate(config.darkspiritConfig());
        checkUrlBase = CHECK_URL_BASE.validate(config.checkUrlBase());
        char firstCgiSeparator;
        if (checkUrlBase.getRawQuery() == null) {
            firstCgiSeparator = '?';
        } else {
            firstCgiSeparator = '&';
        }
        checkUrlBaseString = checkUrlBase.toASCIIString() + firstCgiSeparator;
        fiscalStoragesConfig =
            FISCAL_STORAGES_CONFIG.validate(config.fiscalStoragesConfig());
        dyngoConfig = DYNGO_CONFIG.validate(config.dyngoConfig());
        fnslinkerConfig = FNSLINKER_CONFIG.validate(config.fnslinkerConfig());
    }

    @Override
    public Path terminalsInfosPath() {
        return terminalsInfosPath;
    }

    @Override
    public ImmutableHttpHostConfig producerStoreConfig() {
        return producerStoreConfig;
    }

    @Override
    public ImmutableHttpHostConfig darkspiritConfig() {
        return darkspiritConfig;
    }

    @Override
    public URI checkUrlBase() {
        return checkUrlBase;
    }

    public String checkUrlBaseString() {
        return checkUrlBaseString;
    }

    @Override
    public ImmutableHttpHostConfig fiscalStoragesConfig() {
        return fiscalStoragesConfig;
    }

    @Override
    public ImmutableHttpHostConfig dyngoConfig() {
        return dyngoConfig;
    }

    @Override
    public ImmutableHttpHostConfig fnslinkerConfig() {
        return fnslinkerConfig;
    }
}

