package ru.yandex.ohio.backend.config;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;

import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.URIParser;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface OhioBackendConfig extends UniversalSearchProxyConfig {
    ParameterConfig<Path> TERMINALS_INFOS_PATH = new ParameterConfig<>(
        "ohio.terminals-infos-path",
        Paths::get,
        GenericFunction.identity());

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        PRODUCER_STORE_CONFIG = new SectionConfig<>(
            "producer-store",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        DARKSPIRIT_CONFIG = new SectionConfig<>(
            "darkspirit",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    ParameterConfig<URI> CHECK_URL_BASE =
        new ParameterConfig<>(
            "darkspirit.check-url-base",
            URIParser.FRAGMENT_STRIPPING,
            GenericFunction.identity());

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        FISCAL_STORAGES_CONFIG = new SectionConfig<>(
            "fiscal-storages",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        DYNGO_CONFIG = new SectionConfig<>(
            "dyngo",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        FNSLINKER_CONFIG = new SectionConfig<>(
            "fnslinker",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    Path terminalsInfosPath();

    HttpHostConfig producerStoreConfig();

    HttpHostConfig darkspiritConfig();

    URI checkUrlBase();

    HttpHostConfig fiscalStoragesConfig();

    HttpHostConfig dyngoConfig();

    HttpHostConfig fnslinkerConfig();
}

