package ru.yandex.ohio.backend.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class OhioBackendConfigBuilder
    extends AbstractOhioBackendConfigBuilder<OhioBackendConfigBuilder>
{
    public OhioBackendConfigBuilder() {
        super(OhioBackendConfigDefaults.INSTANCE);
    }

    public OhioBackendConfigBuilder(final OhioBackendConfig config) {
        super(config);
    }

    public OhioBackendConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, OhioBackendConfigDefaults.INSTANCE);
    }

    public OhioBackendConfigBuilder(
        final IniConfig config,
        final OhioBackendConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public OhioBackendConfigBuilder self() {
        return this;
    }

    public ImmutableOhioBackendConfig build() throws ConfigException {
        return new ImmutableOhioBackendConfig(this);
    }
}

