#!/bin/bash
set -exo pipefail

source recommended_search_backend_args.sh

export INDEX_DIR=/data/index

export LOGROTATE_DAYS=10

export SHARDS_PER_HOST=62

export SEARCH_PORT=81
export INDEXER_PORT=82
export DUMP_PORT=86
export OLD_SEARCH_PORT=84
export OHIO_BACKEND_PORT=80
export OHIO_BACKEND_HTTPS_PORT=443
export PRODUCER_PORT=8080
export PRODUCER_HTTPS_PORT=8443
export CONSUMER_PORT=89

export WATCHDOG_QUEUE_NAME=ohio_watchdog
export WATCHDOG_ZOO_SHARD_ID=0
export WATCHDOG_PREFIX=0

export SEARCHMAP_PATH=searchmap.txt

export TVM_API_HOST=https://tvm-api.yandex.net
export TVM_CLIENT_ID=2021217
export ALLOWED_SRCS=2021183

export BALANCER_NAME=ohio-backend.so.yandex.net

export SERVICE_CONFIG=empty.conf

export DARKSPIRIT_HOST=https://darkspirit.yandex.net/
export DARKSPIRIT_TVM_ID=2000476
export CHECK_URL_BASE=https://check.yandex.ru/pdf

export DYNGO_HOST=https://cashbachnica.edadeal.yandex.net
export DYNGO_TVM_ID=2027318
export FNSLINKER_HOST=https://fnslinker.edadeal.ru
export FNSLINKER_TVM_ID=2027120

export BUNKER_URI="http://bunker-api.yandex.net/v1/cat?node=/passport-order-history/config&version=latest"

export TERMINALS_INFOS_PATH=terminals.json

export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.8)}')

GB=$(( 1024*1024*1024 ))
GB1_5=$(( GB + (GB / 2) ))
export MEMORY_GAP=${MEMORY_GAP:-$GB1_5}

if [ "$INSTANCE_TAG_CTYPE" = "test" ]
then
    export SEARCHMAP_PATH=searchmap_test.txt
    export LOGROTATE_DAYS=2
    export TVM_CLIENT_ID=2021145
    export ALLOWED_SRCS=2021181
    export BALANCER_NAME=ohio-backend-test.so.yandex.net
    export SERVICE_CONFIG=ohio_backend_test.conf

    export DARKSPIRIT_HOST=https://darkspirit.testing.yandex.net/
    export DARKSPIRIT_TVM_ID=2000447
    export CHECK_URL_BASE=https://greed-ts.paysys.yandex.net:8019/pdf

    export DYNGO_HOST=https://cashbachnica.edastage.yandex.net
    export DYNGO_TVM_ID=2027316
    export FNSLINKER_HOST=https://fnslinker.edastage.ru
    export FNSLINKER_TVM_ID=2027118

    export BUNKER_URI="http://bunker-api-dot.yandex.net/v1/cat?node=/passport-order-history-test/config&version=latest"
fi

if [ "$INSTANCE_TAG_CTYPE" = "prestable" ]
then
    export LOGROTATE_DAYS=7
    export BALANCER_NAME=ohio-backend-rc.so.yandex.net

    export SEARCH_PORT=
    export INDEXER_PORT=
    export DUMP_PORT=
    export OLD_SEARCH_PORT=
    export OHIO_BACKEND_PORT=80
    export OHIO_BACKEND_HTTPS_PORT=443
    export PRODUCER_PORT=8080
    export PRODUCER_HTTPS_PORT=8443
    export CONSUMER_PORT=
    export BUNKER_URI="http://bunker-api.yandex.net/v1/cat?node=/passport-order-history-test/config&version=latest"
fi

