#!/bin/bash
set -exo pipefail

source config.sh

STATUS_PORTS=(
$OHIO_BACKEND_PORT
$PRODUCER_PORT
$CONSUMER_PORT
)

HTTPS_STATUS_PORTS=(
$OHIO_BACKEND_HTTPS_PORT
$PRODUCER_HTTPS_PORT
)

PING_PORTS=(
$INDEXER_PORT
$DUMP_PORT
$SEARCH_PORT
)

if [ -n "$INDEXER_PORT" ]
then
    source check_search_backend_copyness_status.sh
fi

end_date=$(expr $(date +%s) + 900)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        >&2 echo Status script timed out
        exit 1
    fi

    # Fast check clients, if any client is in any state except ACTIVE, exit 1
    # If /status is not available, probably service is not started yet,
    # just skip this check
    for status_port in ${STATUS_PORTS[@]}
    do
        if ! FAIL_FAST_EXIT_CODE=0 PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
        then
            >&2 echo "Port $status_port /status check failed"
            exit 1
        fi
    done

    for status_port in ${HTTPS_STATUS_PORTS[@]}
    do
        if ! FAIL_FAST_EXIT_CODE=0 PORT=$status_port SCHEME=https CURL_OPTS="-k" REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
        then
            >&2 echo "Https port $status_port /status check failed"
            exit 1
        fi
    done

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            >&2 echo "Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    if [ -n "$INDEXER_PORT" ]
    then
        WATCHDOG_VERSION=$(date +%s)
        code=$(curl -sm 10 -o /dev/null -w '%{http_code}' -H "ZooShardId: $WATCHDOG_ZOO_SHARD_ID" -H "ZooQueue: $WATCHDOG_QUEUE_NAME" -H "ZooQueueId: $WATCHDOG_VERSION" --data-binary '{"prefix":'$WATCHDOG_PREFIX',"docs":[]}' "http://localhost:$INDEXER_PORT/delete?watchdog&zoo-queue-id=$WATCHDOG_VERSION&check-copyness=false" || echo $?)
        if [ $code != 200 ]
        then
            >&2 echo "Indexation failed"
            sleep 1
            continue
        fi
    fi
    break
done

sleep 5
for status_port in ${STATUS_PORTS[@]}
do
    if ! PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
    then
        >&2 echo "Port $status_port /status second check failed"
        exit 1
    fi
done

failed=0
for ping_port in ${PING_PORTS[@]}
do
    if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
    then
        >&2 echo "Port $ping_port /ping second check failed"
        exit 1
    fi
done

exit 0

