package ru.yandex.ohio.indexer.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractOhioIndexerConfigBuilder
    <T extends AbstractOhioIndexerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements OhioIndexerConfig
{
    private HttpHostConfigBuilder producerStoreConfig;

    protected AbstractOhioIndexerConfigBuilder(
        final OhioIndexerConfig config)
    {
        super(config);
        producerStoreConfig(config.producerStoreConfig());
    }

    protected AbstractOhioIndexerConfigBuilder(
        final IniConfig config,
        final OhioIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        producerStoreConfig = PRODUCER_STORE_CONFIG.extract(
            config,
            defaults.producerStoreConfig());
    }

    @Override
    public HttpHostConfigBuilder producerStoreConfig() {
        return producerStoreConfig;
    }

    public T producerStoreConfig(final HttpHostConfig producerStoreConfig) {
        this.producerStoreConfig =
            new HttpHostConfigBuilder(producerStoreConfig);
        return self();
    }
}

