package ru.yandex.ohio.indexer.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableOhioIndexerConfig
    extends ImmutableHttpProxyConfig
    implements OhioIndexerConfig
{
    private final ImmutableHttpHostConfig producerStoreConfig;

    public ImmutableOhioIndexerConfig(final OhioIndexerConfig config)
        throws ConfigException
    {
        super(config);
        producerStoreConfig =
            PRODUCER_STORE_CONFIG.validate(config.producerStoreConfig());
    }

    @Override
    public ImmutableHttpHostConfig producerStoreConfig() {
        return producerStoreConfig;
    }
}

