package ru.yandex.ohio.indexer.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class OhioIndexerConfigBuilder
    extends AbstractOhioIndexerConfigBuilder<OhioIndexerConfigBuilder>
{
    public OhioIndexerConfigBuilder() {
        super(OhioIndexerConfigDefaults.INSTANCE);
    }

    public OhioIndexerConfigBuilder(final OhioIndexerConfig config) {
        super(config);
    }

    public OhioIndexerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, OhioIndexerConfigDefaults.INSTANCE);
    }

    public OhioIndexerConfigBuilder(
        final IniConfig config,
        final OhioIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public OhioIndexerConfigBuilder self() {
        return this;
    }

    public ImmutableOhioIndexerConfig build() throws ConfigException {
        return new ImmutableOhioIndexerConfig(this);
    }
}

