#!/bin/bash
set -exo pipefail

export DATA_DIR=/data
export ADDITIONAL_ARGS="
-DPORTO=1
-Dzoolooser.traffic-compress.zstd=false
-Dzoolooser.min-docs-in-memory-queue=5
-XX:ActiveProcessorCount=7
-Dru.yandex.lucene.default-cache-size=$((512 * 1024 * 1024))
-Dru.yandex.lucene.fsync-bytes-interval=$((128 * 1024 * 1024))
-Dru.yandex.lucene-storage.index-threads=3
-Dru.yandex.lucene-storage.merge-threads=4
-Dru.yandex.lucene-storage.max-live-data-size=$((512 * 1024 * 1024))
-Dru.yandex.lucene-storage.max-cache-weight=$((512 * 1024 * 1024))
-Dru.yandex.lucene-storage.max-segment-size=$((512 * 1024 * 1024))
-Dru.yandex.lucene-queue.ram-buffer-size-mb=256
-Dru.yandex.lucene-storage.zoo-hash-bloom-filter=false
-Dru.yandex.lucene-storage.in-memory-fields-index=false"
export MEMORY_GAP=$((1024 * 1024 * 1024))
export ARGS="queue.cfg server.conf"

