CREATE TYPE ohio.order_status AS ENUM ('paid', 'cancelled', 'refunded');
CREATE TYPE ohio.service_type AS ENUM ('payments', 'trust');

CREATE TABLE ohio.services (
    service_id BIGSERIAL PRIMARY KEY,
    service_type ohio.service_type NOT NULL,
    tvm_id BIGINT DEFAULT NULL UNIQUE,
    trust_service_id TEXT DEFAULT NULL UNIQUE,
    payments_service_id BIGINT DEFAULT NULL UNIQUE,
    enabled BOOLEAN DEFAULT TRUE NOT NULL,
    created TIMESTAMPTZ DEFAULT NOW() NOT NULL,
    updated TIMESTAMPTZ DEFAULT NOW() NOT NULL
);

CREATE INDEX services_payments_service_id
    ON ohio.services (payments_service_id)
    WHERE payments_service_id IS NOT NULL;


CREATE TABLE ohio.customers (
    customer_uid BIGINT PRIMARY KEY,
    next_order_id BIGINT DEFAULT 1 NOT NULL,
    created TIMESTAMPTZ DEFAULT NOW() NOT NULL,
    updated TIMESTAMPTZ DEFAULT NOW() NOT NULL
);

CREATE TABLE ohio.orders (
    customer_uid BIGINT,
    order_id BIGINT,
    service_id BIGINT NOT NULL,
    subservice_id TEXT,

    merchant_uid BIGINT,
    service_merchant_id BIGINT,
    payments_order_id BIGINT,

    trust_payment_id TEXT,
    trust_purchase_token TEXT UNIQUE,

    status ohio.order_status,
    order_data JSONB,
    order_revision BIGINT NOT NULL,
    service_data JSONB,
    service_revision BIGINT NOT NULL,

    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW() NOT NULL,

    PRIMARY KEY (customer_uid, order_id),
    CONSTRAINT fk_orders_customer_uid_on_customers_customer_uid
        FOREIGN KEY (customer_uid) REFERENCES ohio.customers ON DELETE RESTRICT,
    CONSTRAINT fk_orders_service_id_on_services_service_id
        FOREIGN KEY (service_id) REFERENCES ohio.services ON DELETE RESTRICT
);

CREATE INDEX orders_customer_uid_idx
    ON ohio.orders (customer_uid)
    WHERE customer_uid IS NOT NULL;

CREATE INDEX orders_trust_purchase_token_idx
    ON ohio.orders (trust_purchase_token)
    WHERE trust_purchase_token IS NOT NULL;

