#!/usr/bin/env bash
if ! type pg-pinger > /dev/null 2>&1; then
    echo "pg-pinger not installed
    Build it from revision mentioned in changelog and add it to your PATH.
    https://a.yandex-team.ru/arc/trunk/arcadia/toolbox/pg-pinger/CHANGELOG.md
    "
    exit 1
fi

pkill -f "pg-pinger" || true

PINGER_HOSTS=0.0.0.0 \
    PINGER_PORT=5252 \
    PINGER_USERNAME=ohio \
    PINGER_PASSWORD="P@ssw0rd" \
    PINGER_DATABASE=ohio_db \
    PINGER_SSLMODE=disable \
    pg-pinger > /dev/null &

self_tvm_id=2021145

if [ -n "$self_tvm_id" ]
then
    export PYTHONPATH=./src
    export QLOUD_TVM_SECRET=$(cat ./.tvm.key)

    [[ -f ./.tvm.port ]] || echo $(( (RANDOM % 100) + 33300 )) > ./.tvm.port
    export TVM_PORT=$(cat ./.tvm.port)

    export QLOUD_TVM_INTERFACE_ORIGIN="http://localhost:$TVM_PORT"
    export QLOUD_TVM_TOKEN=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
    export QLOUD_TVM_CONFIG=$(
        jq -n --arg secret "$QLOUD_TVM_SECRET" --argjson self_tvm_id "$self_tvm_id" '{
            "BbEnvType": 0,
            "clients": {
                "ohio": {
                    "secret": $secret,
                    "self_tvm_id": $self_tvm_id,
                    "dsts": {
                        "ohio": {
                            "dst_id": $self_tvm_id
                        }
                    }
                }
            }
        }'
    )

    echo $QLOUD_TVM_CONFIG > .tvm.json
    # clean up prev. tvmtool run
    pkill -f "tvmtool.*$TVM_PORT" || true
    tvmtool --port $TVM_PORT -a $QLOUD_TVM_TOKEN -c .tvm.json > /dev/null &
fi

make start_db

while [ "$1" != "" ]; do
    case $1 in
        -w  )
            shift
            exec watchmedo auto-restart -R -p "*.py;*.conf;*ya.make" -- "$@"
                                ;;
        * )
            exec "$@"
    esac
    shift
done
