import argparse
from tornado import ioloop
import time
import json

from mail.oracle_mids_mapping.lib.server import WebThread
import mail.oracle_mids_mapping.lib.settings as settings


def parse_args():
    parser = argparse.ArgumentParser(description='Service for mapping ora mids to pg mids')
    parser.add_argument('-c', '--config', required=True, help='Path to config')
    return parser.parse_args()


def main():
    args = parse_args()

    if not args.config:
        raise 'Invalid path to the config'

    settings.init_settings(args.config)

    workers = []
    for t in range(settings.conf['Daemon']['Threads']):
        worker = WebThread('Thread #%s' % t)
        workers.append(worker)
        worker.start()
    loop = ioloop.IOLoop.instance()
    try:
        loop.start()
    except KeyboardInterrupt:
        log_msg = {'unixtime': time.time(),
                   'date': time.ctime(),
                   'message': 'Daemon exit'
                   }
        settings.service_logger.info(json.dumps(log_msg))
        for w in workers:
            w.stop()

    finally:
        loop.close()
    return 0


if __name__ == "__main__":
    main()
