import psycopg2


class DB():
    def __init__(self, conf):
        self.db_ = None
        self.dbname = conf['DB']['DBName']
        self.user = conf['DB']['User']
        self.host = conf['DB']['Host']
        self.port = conf['DB']['Port']
        self.password = None
        self.conn_timeout = conf['DB']['ConnectTimeout']
        if 'Password' in conf['DB']:
            self.password = conf['DB']['Password']

    def __del__(self):
        if self.db_ is not None:
            self.db_.close()

    def db(self):
        if self.db_ is None:
            self.db_ = psycopg2.connect(database=self.dbname, user=self.user, password=self.password, host=self.host, port=self.port, connect_timeout=self.conn_timeout)
        return self.db_

    def cursor(self):
        return self.db().cursor()

    def fetchall(self, query, vars):
        c = self.cursor()
        c.execute(query, vars)
        return c.fetchall()
