import yaml
import logging


def init_settings(conf_path):
    global conf
    global error_logger
    global service_logger
    global access_logger
    global http_logger
    error_logger = logging.getLogger('Error')
    service_logger = logging.getLogger('Service')
    access_logger = logging.getLogger('Access')
    http_logger = logging.getLogger('Http')

    with open(conf_path, 'r') as f:
        conf = yaml.load(f.read())

    access_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['AccessLog'], mode='a',
                                                         encoding=None, delay=False)
    access_logger.addHandler(access_handler)
    access_logger.setLevel(logging.INFO)
    access_logger.propagate = False

    http_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['HttpLog'], mode='a',
                                                       encoding=None, delay=False)
    http_logger.addHandler(http_handler)
    http_logger.setLevel(logging.INFO)
    http_logger.propagate = False

    error_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['ErrorLog'], mode='a',
                                                        encoding=None, delay=False)
    error_logger.addHandler(error_handler)
    error_logger.setLevel(logging.ERROR)
    error_logger.propagate = False

    service_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['ServiceLog'], mode='a',
                                                          encoding=None, delay=False)
    service_logger.addHandler(service_handler)
    service_logger.setLevel(logging.INFO)
    service_logger.propagate = False
