# ozo

Надстройка над библиотекой https://github.com/yandex/ozo для интергации в аркадию. Создана, чтобы отделить описание сборки в аркадии, а также специфичный для внутреннего использования код от внешнего проекта.

## Яндекс специфичная функциональность
Для добавления в проект функциональности специфичной для Яндекс существует папка [include/ozo/yandex](https://a.yandex-team.ru/arc/trunk/arcadia/mail/ozo/include/ozo/yandex).

## Синхронизация

Код библиотеки синхронизируется в папку [github](https://a.yandex-team.ru/arc/trunk/arcadia/mail/ozo/github) с помощью [jenkins](https://common.jenkins.mail.yandex.net/job/ozo_sync/).

Нижеописанные скрипты должны использоваться для соответствующих им операций.

### Переключение на бранч

`git_checkout.sh [parameters] {branch|commit-id}`

Переключает `HEAD` на указанный бранч или коммит. При этом выполняются все необходимые операции:

* `git checkout <branch|commit-id>`,
* генерация `ya.make` файлов,
* накладывает патчи предназначенные для соответствующего `commit-id`,
* обновление файла `github/.id`, содержащего id `HEAD`.

Скрипт автоматически определяет запуск из Jenkins по наличию одновременно трёх переменных `JENKINS_HOME`, `JENKINS_URL`, `JENKINS_SERVER_COOKIE` и устанавливает флаг `set -x`.

#### Параметры

| Параметр | Аргумент | Описание |
|----------|----------|----------|
| `-f`, `--force` | - | Затирать все локальные изменения; по-умолчанию - не затирать. |
| `-g`, `--generate_ya_make` | - | Форсировать сборку утилиты `generate_ya_make`; по-умолчанию - сборка происходит только если утилита не была найдена. |
| `-d`, `--directory` | путь | Использовать указанный путь к корню проекта в Аркадии; по-умолчанию - текущая директория. |
| `-h`, `--help` | - | Быстрая помощь по запуску. |

#### Возвращает

| Код | Описание |
|-----|----------|
| `0` | Успешное завершение. |
| `255` | Неверный параметр запуска .|
| `иной код ошибки` | Используемые утилиты вернули ошибку. |

#### Переменные среды

| Переменная | Описание |
|------------|----------|
| `YA` | Путь до утилиты `ya`, значение по-умолчанию `ya`. |

#### Пример

`./git_checkout.sh -f -d mail/ozo origin/master`

Переключает на `origin/master` проект расположенный по относительному пути `mail/ozo` с потерей всех локальных изменений.

### Запуск/проверка состояния теста в CI

`check_ci.sh [parameters]`

Запускает проверку текущего кода с помощью `ya check` и отслеживает её состояние в CI через [API](https://ci.yandex-team.ru/api/v1.0/swagger-ui.html#!/checks45web45service/checkUsingGET) ([Wiki](https://wiki.yandex-team.ru/CI/)).

Скрипт автоматически определяет запуск из Jenkins по наличию одновременно трёх переменных `JENKINS_HOME`, `JENKINS_URL`, `JENKINS_SERVER_COOKIE` и устанавливает флаг `set -x`.

#### Параметры

| Параметр | Аргумент | Описание |
|----------|----------|----------|
| `-j`, `--job` | job-id | Не запускать новую, а отслеживать существующую проверку с указанным job-id. |
| `-p`, `--poll-timeout` | timeout | Поллить состояние проверки с указанным timeout, по-умолчанию - 20 секунд. |
| `-d`, `--directory` | путь | Использовать указанный путь к корню проекта в Аркадии; по-умолчанию - текущая директория. |
| `-h`, `--help` | - | Быстрая помощь по запуску. |

#### Возвращает

| Код | Описание |
|-----|----------|
| `0` | Все проверки прошли успешно. |
| `200` | Проверка выдала результат отличный от `PASSED`. |
| `250` | Не удалось получить ID тестов. |
| `255` | Неверный параметр запуска. |
| `иной код ошибки` | если `ya check` или `curl` вернули ошибку. |

#### Переменные среды

| Переменная | Описание |
|------------|----------|
| `YA` | Путь до утилиты `ya`, значение по-умолчанию `ya`. |

#### Пример

`./check_ci.sh -t 5 -d mail/ozo`

Запускает проверку кода проекта расположенного по относительному пути `mail/ozo` с частотой поллинга раз в `5` секунд.
