#pragma once

/**
 * @defgroup group-core Core
 * @brief Core utilities of the library.
 */

/**
 * @defgroup group-core-functions Functions
 * @ingroup group-core
 * @brief Core utility functions of the library.
 */

/**
 * @defgroup group-core-types Types
 * @ingroup group-core
 * @brief Core utility types of the library.
 */

/**
 * @defgroup group-requests Database requests
 * @brief Database requests related concepts, types and functions.
 */

/**
 * @defgroup group-requests-functions Functions
 * @ingroup group-requests
 * @brief Database requests related functions.
 */

/**
 * @defgroup group-requests-types Types
 * @ingroup group-requests
 * @brief Database requests related types.
 */

/**
 * @defgroup group-ext External adaptors
 * @brief External type adaptors.
 *
 * The Library can be extended via specialization of different
 * functors and traits. Here in-library eternal type adaptors are collected.
 * Use it as an example of external types adaptation.
 */

#include <ozo/connection_pool.h>

namespace ozo {

} // namespace ozo
