#pragma once

#include <ozo/yandex/logdog/attributes.h>
#include <ozo/yandex/mdb/strategy.h>
#include <logdog/logger.h>

namespace ozo::yandex::mdb {

LOGDOG_DEFINE_ATTRIBUTE(std::string_view, role);
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, strategy);

template <typename Strategy, typename Logger>
constexpr auto attach_fallback_logging(Strategy&& s, Logger logger) {
    return std::forward<Strategy>(s).set(
        using namespace ::logdog::attr;
        using namespace ::ozo::yandex::logdog;
        options::on_fallback=[logger] (ozo::error_code ec, auto& conn, const auto& a_try) {
            LOGDOG_(logger, warning,
                message="query failed and will fallback",
                error_code=ec,
                connection=conn,
                query_name=query,
                role=hana::to<const char*>(name(a_try.role())),
                strategy=hana::to<const char*>(a_try.options()[options::name])
            );
        });
}

} // namespace ozo::yandex::mdb
