#pragma once

#include <ozo/yandex/mdb/role.h>
#include <ozo/failover/role_based.h>

#include <variant>

namespace ozo::yandex::mdb {

/**
 * @brief Options for strategies
 *
 * Extends options of ozo::failover::role_based_options
 */
struct options : ozo::failover::role_based_options {
    class name_tag;
    static constexpr ozo::option<name_tag> name{}; //!< name of a strategy
};

constexpr auto master_preferred = ozo::failover::role_based(
    master,
    on<errc::connection_error, errc::type_mismatch>.use(master),
    on<errc::user_removed, errc::no_endpoint>.use(master, with_force_update),
    on<errc::connection_error, errc::no_endpoint>.use(replica<1>),
    on<errc::connection_error, errc::no_endpoint>.use(replica<2>)
).set(
    options::name=BOOST_HANA_STRING("master_preferred"),
    options::close_connection=no
);

constexpr auto master_only = ozo::failover::role_based(
    master,
    on<errc::connection_error, errc::type_mismatch>.use(master),
    on<errc::database_read_only, errc::user_removed, errc::no_endpoint>.use(master, with_force_update)
).set(
    options::name=BOOST_HANA_STRING("master_only"),
    options::close_connection=no
);

constexpr auto actual_replica_only = ozo::failover::role_based(
    actual_replica,
    on<errc::connection_error, errc::type_mismatch>.use(actual_replica),
    on<errc::user_removed, errc::no_endpoint>.use(actual_replica, with_force_update)
).set(
    options::name=BOOST_HANA_STRING("actual_replica_only"),
    options::close_connection=no
);

constexpr auto lagging_replica_only = ozo::failover::role_based(
    lagging_replica,
    on<errc::connection_error, errc::type_mismatch>.use(lagging_replica),
    on<errc::user_removed, errc::no_endpoint>.use(lagging_replica, with_force_update)
).set(
    options::name=BOOST_HANA_STRING("lagging_replica_only"),
    options::close_connection=no
);

constexpr auto replica_preferred = ozo::failover::role_based(
    replica<1>,
    on<errc::connection_error, errc::type_mismatch>.use(replica<1>),
    on<errc::user_removed, errc::no_endpoint>.use(replica<1>, with_force_update),
    on<errc::connection_error, errc::no_endpoint>.use(replica<2>),
    on<errc::connection_error, errc::no_endpoint>.use(master)
).set(
    options::name=BOOST_HANA_STRING("replica_preferred"),
    options::close_connection=no
);

constexpr auto replica_only = ozo::failover::role_based(
    replica<1>,
    on<errc::connection_error, errc::type_mismatch>.use(replica<1>),
    on<errc::user_removed, errc::no_endpoint>.use(replica<1>, with_force_update),
    on<errc::connection_error, errc::no_endpoint>.use(replica<2>)
).set(
    options::name=BOOST_HANA_STRING("replica_only"),
    options::close_connection=no
);

constexpr auto actual_replica_preferred = ozo::failover::role_based(
    actual_replica,
    on<errc::connection_error, errc::type_mismatch>.use(actual_replica),
    on<errc::user_removed, errc::no_endpoint>.use(actual_replica, with_force_update),
    on<errc::connection_error, errc::no_endpoint>.use(master),
    on<errc::connection_error, errc::no_endpoint>.use(lagging_replica)
).set(
    options::name=BOOST_HANA_STRING("actual_replica_preferred"),
    options::close_connection=no
);

template <typename ...Ts>
constexpr std::variant<Ts...> make_variant_type(const Ts& ...);

} // namespace ozo::yandex::mdb

namespace ozo {

template <typename Operation, typename ...Ts>
struct construct_initiator_impl<std::variant<Ts...>, Operation> {
    constexpr static auto apply(const std::variant<Ts...>& v, const Operation& op) {
        return std::visit([&](auto& f) { return construct_initiator(f, op); }, v);
    }
};

} // namespace ozo
