#ifndef _PA_PROFILER_STACK_H_
#define	_PA_PROFILER_STACK_H_


#include <string>
#include <vector>
#include <pa/async.h>
#include <pa/stimer.h>
#include <boost/thread/tss.hpp>

namespace pa {

template <typename Profiler>
class base_stack_profiler
{
private:
  typedef std::vector<base_stack_profiler*> stack_t;
  typedef boost::thread_specific_ptr<stack_t> stack_ptr;
  typedef singleton<stack_ptr> storage;
public:
  base_stack_profiler (pa::rem_type type, const std::string& host = "", const std::string& req = "")
    : profile_type_(type), host_(host), req_(req)
    , stack_(storage::get ().get ())
  {
    if( !stack_ ) {
      storage::get ().reset (new stack_t);
      stack_ = storage::get ().get ();
    }
    push_nested();
  }
  ~base_stack_profiler () {
    profiler_.add (profile_type_, host_, req_, suid_, timer_.stop());
    pop_nested ();
  }
  void set_host (const string& host) {
    host_ = host;
  }
  void set_request (const string& req) {
    req_ = req;
  }
  void set_suid (const string& suid) {
    suid_ = suid;
  }
  void pause () {
    timer_.pause();
  }
  void resume() {
    timer_.resume();
  }

private:
  void push_nested() {
    assert (stack_);
    if (!stack_->empty())
      stack_->back()->pause();
    stack_->push_back(this);
  }
  void pop_nested() {
    assert (stack_ && !stack_->empty() && stack_->back() == this);
    stack_->pop_back();
    if (!stack_->empty()) {
      stack_->back()->resume();
    }
  }

  pa::pause_stimer_t timer_;
  Profiler profiler_;
  pa::rem_type profile_type_;
  string host_;
  string req_;
  string suid_;
  stack_t* stack_;
};

typedef base_stack_profiler<async_profiler> async_stack_profiler;
typedef base_stack_profiler<wmi_profiler> sync_stack_profiler;

}

#endif // _PA_PROFILER_STACK_H_

