#ifndef _PA_PROFILER_STIMER_H_
#define _PA_PROFILER_STIMER_H_

#include <stdint.h>
#include <chrono>

namespace pa {

class stimer_t
{
protected:
  using clock = std::chrono::steady_clock;
  using milliseconds = std::chrono::milliseconds;
public:
  stimer_t()
    : has_run_(0), running_(false)
  {
    start();
  }
  void start ()
  {
    initiated_ = clock::now();
    running_=true;
  }
  uint32_t stop () // milliseconds
  {
    if(running_) {
      has_run_=shot();
      running_=false;
    }
    return has_run_;
  }

  uint32_t shot() // milliseconds
  {
    return static_cast<uint32_t>(std::chrono::duration_cast<milliseconds>(clock::now()-initiated_).count());
  }
protected:
  clock::time_point initiated_;
  uint32_t has_run_;
  bool running_;
};

class pause_stimer_t : public stimer_t
{
public:
  void pause() {
    paused = stimer_t::clock::now();
  }
  void resume() {
    initiated_ += (stimer_t::clock::now()-paused);
  }
private:
  clock::time_point paused;
};

}

#endif // _PA_PROFILER_STIMER_H_
