%define _builddir	.
%define _sourcedir	.
%define _specdir	.
%define _rpmdir		.

Name:		pa
Version:	%{yandex_mail_version}
Release:	%{yandex_mail_release}

Summary:	Profiler analyzer
License:	Yandex License
Group:		System Environment/Libraries
Distribution:	Red Hat Enterprise Linux
URL:		https://github.yandex-team.ru/mail/pa

Source0:	pa.cron.d
Source1:	pa-logrotate.sh

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root


%description
Profiler analyzer


%package	devel
Summary:	Profiler analyzer development environment
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}


%description	devel
Set of headers for pa 


%prep


%build
cmake . -DCMAKE_INSTALL_PREFIX=/usr \
        -DCMAKE_INSTALL_RPATH_USE_LINK_PATH=TRUE \
        -DCMAKE_INSTALL_SYSCONFDIR=/etc \
        -DCMAKE_INSTALL_SHAREDIR=/usr/share \
        -DCMAKE_INSTALL_LIBDIR=lib64 \
        -DCMAKE_BUILD_TYPE=Release
%{__make} %{?_smp_mflags}


%install
%{__rm} -rf %{buildroot}
%{__make} install DESTDIR=%{buildroot}

%{__mkdir_p} %{buildroot}/%{_sysconfdir}/cron.d
%{__mkdir_p} %{buildroot}/%{_sysconfdir}/cron.yandex

%{__install} -m644 %{SOURCE0} %{buildroot}/%{_sysconfdir}/cron.d/pa
%{__install} -m755 %{SOURCE1} %{buildroot}/%{_sysconfdir}/cron.yandex/pa-logrotate.sh


%post
if [ ! -f /var/log/profiler.log ]; then
	touch /var/log/profiler.log;
	chmod 666 /var/log/profiler.log;
fi


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%{_bindir}/pa
%{_sysconfdir}/cron.d/pa
%{_sysconfdir}/cron.yandex/pa-logrotate.sh
%{_datarootdir}/cmake_helpers/FindPA.cmake


%files devel
%defattr(-,root,root)
%{_includedir}/pa/interface.h
%{_includedir}/pa/stimer.h
%{_includedir}/pa/singleton.h
%{_includedir}/pa/async.h
%{_includedir}/pa/stack.h
%{_includedir}/pa/logger.h
/usr/share/cmake_helpers/FindPA.cmake
/usr/share/cmake_helpers/find_pa_dependencies.cmake

%changelog
* Thu Apr 1 2010 Igor Milyakov <virtan@yandex-team.ru> 
- initial yandex's rpm build
