package httputil

import (
	"a.yandex-team.ru/library/go/core/log"
	"encoding/json"
	"net/http"
)

func SuccessResponse(w http.ResponseWriter, data interface{}, logger log.Logger) {
	w.WriteHeader(http.StatusOK)
	if err := json.NewEncoder(w).Encode(data); err != nil {
		logger.Error("Failed to render JSON response", log.Error(err))
	}
}
