package api

import (
	"net/http"
	"time"
)

type MeasurableResponseWriter struct {
	w          http.ResponseWriter
	statusCode int
	startTime  time.Time
}

func NewMeasurableResponseWriter(w http.ResponseWriter) *MeasurableResponseWriter {
	return &MeasurableResponseWriter{
		w:          w,
		statusCode: http.StatusOK,
		startTime:  time.Now(),
	}
}

func (sw *MeasurableResponseWriter) Header() http.Header {
	return sw.w.Header()
}

func (sw *MeasurableResponseWriter) Write(bytes []byte) (int, error) {
	return sw.w.Write(bytes)
}

func (sw *MeasurableResponseWriter) WriteHeader(statusCode int) {
	sw.statusCode = statusCode
	sw.w.WriteHeader(statusCode)
}

func (sw *MeasurableResponseWriter) StatusCode() int {
	return sw.statusCode
}
