package v1

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/api/httputil"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/logic/models"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/tracing"
	"net/http"
)

func (api *V1Api) BankAppsIOS(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	tracing.SetOperationName(ctx, "Get iOS NSPK bank apps")

	res := api.ns.GetBankAppsIOS(ctx)

	resp := iOSResponse{Status: "success", BankApps: res}
	httputil.SuccessResponse(w, &resp, ctxutil.GetLogger(ctx))
}

type iOSResponse struct {
	Status   string                  `json:"status"`
	BankApps []models.NspkBankAppIOS `json:"bank_apps"`
}

func (api *V1Api) BankAppsAndroid(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	tracing.SetOperationName(ctx, "Get Android NSPK bank apps")

	res := api.ns.GetBankAppsAndroid(ctx)

	resp := androidResponse{Status: "success", BankApps: res}
	httputil.SuccessResponse(w, &resp, ctxutil.GetLogger(ctx))
}

type androidResponse struct {
	Status   string                      `json:"status"`
	BankApps []models.NspkBankAppAndroid `json:"bank_apps"`
}

func (api *V1Api) BankAppsCommon(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	tracing.SetOperationName(ctx, "Get Common NSPK bank apps")

	res := api.ns.GetBankAppsCommon(ctx)

	resp := commonResponse{Status: "success", BankApps: res}
	httputil.SuccessResponse(w, &resp, ctxutil.GetLogger(ctx))
}

type commonResponse struct {
	Status   string                     `json:"status"`
	BankApps []models.NspkBankAppCommon `json:"bank_apps"`
}
