package v1

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/api/httputil"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/logic/models"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/tracing"
	"net/http"
)

func (api *V1Api) PaymentMethods(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	uid := ctxutil.GetUID(ctx)
	serviceToken := ctxutil.GetServiceToken(ctx)

	tracing.SetOperationName(ctx, "List available payment methods")

	pm, err := api.ps.PaymentMethodsDefault(ctx, uid, serviceToken, models.PaymentSystemsOptions{GooglePayEnabled: true, ApplePayEnabled: true})
	if err != nil {
		httputil.LogErrorAndDie(ctx, w, httputil.ServiceErrorStatusCodeInfra, err, "internal error")
		return
	}

	resp := paymentMethodsResponse{Status: "success", UserPaymentMethods: pm}
	httputil.SuccessResponse(w, &resp, ctxutil.GetLogger(ctx))
}

type paymentMethodsResponse struct {
	Status string `json:"status"`
	models.UserPaymentMethods
}
