package v1

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/api/httputil"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/tracing"
	"encoding/json"
	"fmt"
	"net/http"
)

func (api *V1Api) VerifyBinding(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	uid := ctxutil.GetUID(ctx)
	serviceToken := ctxutil.GetServiceToken(ctx)

	tracing.SetOperationName(ctx, "Verify card binding")

	req := VerifyBindingRequest{}

	err := json.NewDecoder(r.Body).Decode(&req)
	if err != nil {
		err = req.Validate()
	}
	if err != nil {
		httputil.ResponseWithInternalServerError(ctx, w, httputil.ServiceErrorStatusCodeIncorrectFormat,
			fmt.Sprintf("body seems to be malformed: %v", err))
		return
	}

	vid, err := api.bs.Verify(ctx, serviceToken, uid, req.BindingID)

	if err != nil {
		httputil.ResponseWithInternalServerError(ctx, w, httputil.ServiceErrorStatusCodeInfra, "internal_error")
		return
	}

	resp := verifyBindingResponse{
		Status:        "success",
		PurchaseToken: vid,
	}

	httputil.SuccessResponse(w, &resp, ctxutil.GetLogger(ctx))
}

type VerifyBindingRequest struct {
	BindingID string `json:"binding_id"`
}

func (r *VerifyBindingRequest) Validate() (err error) {
	// TODO: add validation
	return
}

type verifyBindingResponse struct {
	Status        string `json:"status"`
	PurchaseToken string `json:"purchase_token"`
}
