package interactions

import (
	"net/url"
	"strings"
)

type HTTPMethod string

const (
	HTTPPost HTTPMethod = "POST"
	HTTPGet  HTTPMethod = "GET"
)

type Request struct {
	APIMethod string
	Method    HTTPMethod
	Body      interface{}
	Headers   *map[string]string
	Params    *map[string]string
}

func MakeURL(baseURL string, path string) (res string, err error) {
	u, err := url.Parse(baseURL)
	if err != nil {
		return
	}
	if u.Path == "/" || strings.HasPrefix(path, "/") {
		u.Path = path
	} else {
		if strings.HasSuffix(u.Path, "/") {
			u.Path = u.Path + path
		} else {
			u.Path = u.Path + "/" + path
		}
	}
	res = u.String()
	return
}
