package bindings

import "context"

type Client interface {
	Verify(ctx context.Context, serviceToken string, uid uint64, bindingID string) (VerificationInfo, error)
}

type Verification struct {
	ID     string `json:"id"`
	Method string `json:"method"`
	Status string `json:"status"`
}

type VerificationInfo struct {
	UID          string       `json:"uid"`
	BindingID    string       `json:"binding_id"`
	Verification Verification `json:"verification"`
}
