package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/bindings"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"context"
	"fmt"
	"strconv"
)

func (c *Client) Verify(ctx context.Context, serviceToken string, uid uint64, bindingID string) (vi bindings.VerificationInfo, err error) {
	result := verifyResponse{}

	headers := map[string]string{
		AuthHeaderKeyXServiceToken: serviceToken,
		AuthHeaderKeyXUid:          strconv.Itoa(int(uid)),
	}

	body := map[string]string{"method": "standard2_3ds"}

	loginID := ctxutil.GetLoginID(ctx)
	if len(loginID) > 0 {
		body["login_id"] = loginID
	}

	err = c.makeRequest(ctx, interactions.Request{
		APIMethod: fmt.Sprintf("bindings/%s/verify/", bindingID),
		Method:    interactions.HTTPPost,
		Body:      body,
		Headers:   &headers,
	}, &result)

	if err != nil {
		return
	}

	vi.Verification = result.Verification
	vi.BindingID = result.BindingID
	vi.UID = result.UID

	return
}

type verifyResponse struct {
	bindings.VerificationInfo
	Status     string `json:"status"`
	StatusCode string `json:"status_code"`
}

func (r *verifyResponse) GetStatus() string {
	return r.Status
}

func (r *verifyResponse) GetMessage() string {
	return r.StatusCode
}
