package blackbox

import (
	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/tracing"
	"context"
	"github.com/opentracing/opentracing-go"
)

type TracingClient struct {
	RealClient blackbox.Client
}

func (t *TracingClient) SessionID(ctx context.Context, req blackbox.SessionIDRequest) (*blackbox.SessionIDResponse, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Validate user cookies in blackbox")
	defer span.Finish()
	return t.RealClient.SessionID(spanCtx, req)
}

func (t *TracingClient) MultiSessionID(ctx context.Context, req blackbox.MultiSessionIDRequest) (*blackbox.MultiSessionIDResponse, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Validate user cookies in blackbox")
	defer span.Finish()
	return t.RealClient.MultiSessionID(spanCtx, req)
}

func (t *TracingClient) OAuth(ctx context.Context, req blackbox.OAuthRequest) (*blackbox.OAuthResponse, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Validate user OAuth token in blackbox")
	defer span.Finish()
	resp, err := t.RealClient.OAuth(spanCtx, req)
	if err != nil {
		tracing.TagErrorWithMessage(spanCtx, "OAuth validation failed", err)
	}
	return resp, err
}

func (t *TracingClient) UserInfo(ctx context.Context, req blackbox.UserInfoRequest) (*blackbox.UserInfoResponse, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Get userinfo from blackbox")
	defer span.Finish()
	return t.RealClient.UserInfo(spanCtx, req)
}

func (t *TracingClient) UserTicket(ctx context.Context, req blackbox.UserTicketRequest) (*blackbox.UserTicketResponse, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Validate TVM user ticket in blackbox")
	defer span.Finish()
	return t.RealClient.UserTicket(spanCtx, req)
}

func (t *TracingClient) CheckIP(ctx context.Context, req blackbox.CheckIPRequest) (*blackbox.CheckIPResponse, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Check user IP in blackbox")
	defer span.Finish()
	return t.RealClient.CheckIP(spanCtx, req)
}
