package impl

import (
	"context"

	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/nspk"
)

func (c *Client) GetProxyAppC2BMembers(ctx context.Context) (nspk.ProxyAppC2BMembers, error) {
	result := nspk.ProxyAppC2BMembers{}

	err := c.makeRequest(ctx, interactions.Request{
		APIMethod: "proxyapp/c2bmembers.json",
		Method:    interactions.HTTPGet,
		Headers:   &map[string]string{},
	}, &result)

	if err != nil {
		return result, err
	}

	return result, nil
}

func (c *Client) GetWellKnownAssetLinks(ctx context.Context) (nspk.DigitalAssetLinks, error) {
	result := nspk.DigitalAssetLinks{}

	err := c.makeRequest(ctx, interactions.Request{
		APIMethod: ".well-known/assetlinks.json",
		Method:    interactions.HTTPGet,
		Headers:   &map[string]string{},
	}, &result)

	if err != nil {
		return result, err
	}

	return result, nil
}
