package nspk

import "context"

type Client interface {
	GetProxyAppC2BMembers(ctx context.Context) (ProxyAppC2BMembers, error)
	GetWellKnownAssetLinks(ctx context.Context) (DigitalAssetLinks, error)
}

type ProxyAppC2BMembers struct {
	Version    string              `json:"version"`
	Dictionary []ProxyAppC2BMember `json:"dictionary"`
}

type ProxyAppC2BMember struct {
	BankName    string `json:"bankName"`
	LogoURL     string `json:"logoURL"`
	Schema      string `json:"schema"`
	PackageName string `json:"package_name,omitempty"`
}

// https://github.com/google/digitalassetlinks/blob/master/well-known/details.md

type DigitalAssetLinks = []DigitalAssetStatement

type DigitalAssetStatement struct {
	Relation []string               `json:"relation"`
	Target   DigitalAssetDescriptor `json:"target"`
}

type DigitalAssetDescriptor struct {
	Namespace              string   `json:"namespace"`
	PackageName            string   `json:"package_name"`
	Sha256CertFingerprints []string `json:"sha256_cert_fingerprints"`
	Comment                string   `json:"comment,omitempty"`
}
