package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/trust"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"context"
	"fmt"
	"strconv"
)

func (c *Client) GetAFPaymentMethods(ctx context.Context, purchaseToken string, serviceToken string, uid uint64) (afm trust.AFPaymentMethods, err error) {
	result := afMethodsResponse{}
	headers := map[string]string{
		AuthHeaderKeyXServiceToken: serviceToken,
	}
	if uid > 0 {
		headers[AuthHeaderKeyXUid] = strconv.Itoa(int(uid))
	}

	params := map[string]string{}
	loginID := ctxutil.GetLoginID(ctx)
	if len(loginID) > 0 {
		params["login_id"] = loginID
	}

	err = c.makeRequest(ctx, interactions.Request{
		APIMethod: fmt.Sprintf("v2/payments/%s/afs_payment_methods", purchaseToken),
		Method:    interactions.HTTPGet,
		Params:    &params,
		Headers:   &headers,
	}, &result)

	if err != nil {
		return
	}

	afm.Status = result.Status
	afm.PaymentMethods = result.PaymentMethods

	return
}

type afMethodsResponse struct {
	trust.AFPaymentMethods
	StatusCode string `json:"status_code"`
}

func (r *afMethodsResponse) GetStatus() string {
	return r.Status
}

func (r *afMethodsResponse) GetMessage() string {
	return r.StatusCode
}
