package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"context"
	"fmt"
	"strconv"
)

func (c *Client) RequestMarkup(ctx context.Context, purchaseToken string, serviceToken string, uid uint64, spasiboAmount string) (err error) {
	result := markupResponse{}
	headers := map[string]string{
		AuthHeaderKeyXServiceToken: serviceToken,
	}
	if uid > 0 {
		headers[AuthHeaderKeyXUid] = strconv.Itoa(int(uid))
	}

	err = c.makeRequest(ctx, interactions.Request{
		APIMethod: fmt.Sprintf("v2/payments/%s/request_markup", purchaseToken),
		Method:    interactions.HTTPPost,
		Body: map[string]string{
			"spasibo_amount": spasiboAmount,
		},
		Headers: &headers,
	}, &result)

	return
}

type markupResponse struct {
	Status     string `json:"status"`
	StatusCode string `json:"status_code"`
}

func (r *markupResponse) GetStatus() string {
	return r.Status
}

func (r *markupResponse) GetMessage() string {
	return r.StatusCode
}
