package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/trust"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"context"
	"strconv"
)

func (c *Client) GetPaymentMethods(ctx context.Context, serviceToken string, uid uint64) (pm trust.PaymentMethods, err error) {
	result := requestMethodsResponse{}
	headers := map[string]string{
		AuthHeaderKeyXServiceToken: serviceToken,
	}
	if uid > 0 {
		headers[AuthHeaderKeyXUid] = strconv.Itoa(int(uid))
	}

	params := map[string]string{"show-enabled": "1"}
	loginID := ctxutil.GetLoginID(ctx)
	if len(loginID) > 0 {
		params["login_id"] = loginID
	}

	err = c.makeRequest(ctx, interactions.Request{
		APIMethod: "v2/payment-methods",
		Method:    interactions.HTTPGet,
		Headers:   &headers,
		Params:    &params,
	}, &result)

	if err != nil {
		return
	}

	pm.Status = result.Status
	pm.EnabledPaymentMethods = result.EnabledPaymentMethods
	pm.BoundPaymentMethods = result.BoundPaymentMethods

	return
}

type requestMethodsResponse struct {
	trust.PaymentMethods
	StatusCode string `json:"status_code"`
}

func (r *requestMethodsResponse) GetStatus() string {
	return r.Status
}

func (r *requestMethodsResponse) GetMessage() string {
	return r.StatusCode
}
