package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/trust"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"context"
	"fmt"
	"strconv"
)

type startPaymentResponse struct {
	trust.StartPaymentInfo
	StatusCode string `json:"status_code"`
}

func (r *startPaymentResponse) GetStatus() string {
	return r.Status
}

func (r *startPaymentResponse) GetMessage() string {
	return r.StatusCode
}

func (c *Client) StartPayment(ctx context.Context, purchaseToken string, serviceToken string, uid uint64, credit bool) (sp trust.StartPaymentInfo, err error) {
	result := startPaymentResponse{}
	headers := map[string]string{
		AuthHeaderKeyXServiceToken: serviceToken,
	}
	if uid > 0 {
		headers[AuthHeaderKeyXUid] = strconv.Itoa(int(uid))
	}

	var url string
	if credit {
		url = fmt.Sprintf("v2/credit/%s/start", purchaseToken)
	} else {
		url = fmt.Sprintf("v2/payments/%s/start", purchaseToken)
	}

	params := map[string]string{}
	loginID := ctxutil.GetLoginID(ctx)
	if len(loginID) > 0 {
		params["login_id"] = loginID
	}

	err = c.makeRequest(ctx, interactions.Request{
		APIMethod: url,
		Method:    interactions.HTTPPost,
		Headers:   &headers,
		Params:    &params,
	}, &result)

	sp.Status = result.Status
	sp.PaymentURL = result.PaymentURL
	sp.CreditFormURL = result.CreditFormURL

	return
}
