package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/trust"
	"context"
	"fmt"
	"strconv"
)

type paymentStatusResponse struct {
	trust.PaymentStatus
	StatusCode string `json:"status_code"`
}

func (r *paymentStatusResponse) GetStatus() string {
	return r.Status
}

func (r *paymentStatusResponse) GetMessage() string {
	return r.StatusCode
}

func (c *Client) GetPaymentStatus(ctx context.Context, purchaseToken string, serviceToken string, uid uint64) (ps trust.PaymentStatus, err error) {
	result := paymentStatusResponse{}
	headers := map[string]string{
		AuthHeaderKeyXServiceToken: serviceToken,
	}
	if uid > 0 {
		headers[AuthHeaderKeyXUid] = strconv.Itoa(int(uid))
	}

	err = c.makeRequest(ctx, interactions.Request{
		APIMethod: fmt.Sprintf("v2/payments/%s", purchaseToken),
		Method:    interactions.HTTPGet,
		Headers:   &headers,
	}, &result)

	if err != nil {
		return
	}

	ps.Status = result.Status
	ps.PurchaseToken = result.PurchaseToken
	ps.Currency = result.Currency
	ps.Orders = result.Orders
	ps.Total = result.Total
	ps.PaymentMarkup = result.PaymentMarkup

	return
}
