package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/trust"
	"context"
	"github.com/opentracing/opentracing-go"
)

type TracingClient struct {
	RealClient *Client
}

func (t *TracingClient) GetPaymentStatus(ctx context.Context, purchaseToken string, serviceToken string, uid uint64) (trust.PaymentStatus, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Get payment status from trust")
	defer span.Finish()
	return t.RealClient.GetPaymentStatus(spanCtx, purchaseToken, serviceToken, uid)
}

func (t *TracingClient) GetPaymentMethods(ctx context.Context, serviceToken string, uid uint64) (trust.PaymentMethods, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Get payment methods from trust")
	defer span.Finish()
	return t.RealClient.GetPaymentMethods(spanCtx, serviceToken, uid)
}

func (t *TracingClient) GetAFPaymentMethods(ctx context.Context, purchaseToken string, serviceToken string, uid uint64) (trust.AFPaymentMethods, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Get antifraud rules for methods from trust")
	defer span.Finish()
	return t.RealClient.GetAFPaymentMethods(spanCtx, purchaseToken, serviceToken, uid)
}

func (t *TracingClient) StartPayment(ctx context.Context, purchaseToken string, serviceToken string, uid uint64, credit bool) (trust.StartPaymentInfo, error) {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Start payment in trust")
	defer span.Finish()
	return t.RealClient.StartPayment(spanCtx, purchaseToken, serviceToken, uid, credit)
}

func (t *TracingClient) RequestMarkup(ctx context.Context, purchaseToken string, serviceToken string, uid uint64, spasiboAmount string) error {
	span, spanCtx := opentracing.StartSpanFromContext(ctx, "Make spasibo markup in trust")
	defer span.Finish()
	return t.RealClient.RequestMarkup(spanCtx, purchaseToken, serviceToken, uid, spasiboAmount)
}
