package impl

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/yapay"
	"context"
)

func (c *Client) StartOrder(ctx context.Context, uid uint64, payToken string, turboappID string, email string) (order yapay.Order, err error) {

	result := &startOrderResponse{}
	headers := make(map[string]string)
	request := interactions.Request{
		APIMethod: "order/start",
		Method:    interactions.HTTPPost,
		Body: startOrderRequest{
			PayToken:    payToken,
			Email:       email,
			CustomerUID: uid,
			TurboappID:  turboappID,
		},
		Headers: &headers,
	}

	err = c.makeRequest(ctx, request, result)

	if err != nil {
		return
	}

	order.PurchaseToken = result.Data.PurchaseToken
	order.AcquirerType = result.Data.AcquierType
	order.Merchant = result.Data.Merchant
	if result.Data.Environment == "prod" {
		order.Environment = "production"
	} else {
		order.Environment = "sandbox"
	}
	return
}

type startOrderRequest struct {
	PayToken    string `json:"pay_token"`
	CustomerUID uint64 `json:"customer_uid,omitempty"`
	Email       string `json:"email,omitempty"`
	TurboappID  string `json:"turboapp_id,omitempty"`
}

type startOrderResponse struct {
	Data struct {
		Message       string         `json:"message"`
		PurchaseToken string         `json:"purchase_token"`
		AcquierType   string         `json:"acquirer"`
		Environment   string         `json:"environment"`
		Merchant      yapay.Merchant `json:"merchant"`
	} `json:"data"`
	Status string `json:"status"`
	Code   int    `json:"code"`
}

func (r *startOrderResponse) GetStatus() string {
	return r.Status
}

func (r *startOrderResponse) GetCode() int {
	return r.Code
}

func (r *startOrderResponse) GetMessage() string {
	return r.Data.Message
}
