package yapay

import "context"

type Client interface {
	StartOrder(ctx context.Context, uid uint64, payToken string, turboappID string, email string) (Order, error)
}

type PaymentSystemsOptions struct {
	ApplePayEnabled  bool `json:"apple_pay_enabled"`
	GooglePayEnabled bool `json:"google_pay_enabled"`
}

type Order struct {
	PurchaseToken         string                `json:"purchase_token"`
	AcquirerType          string                `json:"acquirer"`
	Environment           string                `json:"environment"`
	PaymentSystemsOptions PaymentSystemsOptions `json:"payment_systems_options"`
	Merchant              Merchant              `json:"merchant"`
}

type LegalAddress struct {
	City    string `json:"city"`
	Country string `json:"country"`
	Home    string `json:"home"`
	Street  string `json:"street"`
	Zip     string `json:"zip"`
}

type Merchant struct {
	Name         string       `json:"name"`
	ScheduleText string       `json:"schedule_text"`
	OGRN         string       `json:"ogrn"`
	LegalAddress LegalAddress `json:"legal_address"`
}
