package provider

import (
	"context"
	"errors"
)

func (s *BindingsService) Verify(ctx context.Context, serviceToken string, uid uint64, bindingID string) (verificationID string, err error) {
	if uid == 0 {
		err = errors.New("user must be authenticated")
		return
	}
	res, err := s.bindingsClient.Verify(ctx, serviceToken, uid, bindingID)
	if err != nil {
		return
	}

	verificationID = res.Verification.ID
	return
}
