package models

import "strings"

type OrderEnvironment string

type PayToken string

func (t PayToken) String() string {
	return string(t)
}

type PayTokenType int

const (
	TokenTypeTrust     PayTokenType = iota
	TokenTypeYaPayment PayTokenType = iota
)

const (
	TokenPrefixYaPayment = "payment:"
	YaMoneyPaymentSystem = "yamoney_wallet"
)

func (t PayToken) Type() PayTokenType {
	if strings.HasPrefix(t.String(), TokenPrefixYaPayment) {
		return TokenTypeYaPayment
	} else {
		return TokenTypeTrust
	}
}

const (
	ProductionOrder OrderEnvironment = "production"
	SandboxOrder    OrderEnvironment = "sandbox"
)

type Order struct {
	AcquirerType string           `json:"acquirer"`
	Token        string           `json:"token"`
	LicenseURL   string           `json:"license_url"`
	Total        string           `json:"total"`
	Currency     string           `json:"currency"`
	Environment  OrderEnvironment `json:"environment"`
}
