package models

import (
	"a.yandex-team.ru/library/go/core/resource"
	"fmt"
	"gopkg.in/yaml.v2"
	"sync"
)

type ResourceProvider interface {
	GetBankNames() map[string]string
}

var initResourceProviderOnce = sync.Once{}
var resourceProvider ResourceProvider

func GetResourceProvider() ResourceProvider {
	initResourceProviderOnce.Do(initResourceProvider)
	return resourceProvider
}

func initResourceProvider() {
	bankNames := loadBankNames()
	resourceProvider = &ResourceProviderImpl{bankNamesData: bankNames}
}

type ResourceProviderImpl struct {
	bankNamesData map[string]string
}

func (p *ResourceProviderImpl) GetBankNames() map[string]string {
	return p.bankNamesData
}

func loadBankNames() map[string]string {
	bankNamesMap := make(map[string]string)

	yamlData := resource.Get("/bank_names")
	if yamlData == nil {
		fmt.Println("Unable to load bank names mapping resource")
		return bankNamesMap
	}

	err := yaml.Unmarshal(yamlData, &bankNamesMap)
	if err != nil {
		fmt.Printf("Unable to load bank names mapping: %v \n", err)
	}

	return bankNamesMap
}
