package cache

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/interactions/nspk"
	"encoding/json"
	"io/ioutil"
	"os"
	"path/filepath"
)

const defaultStaticNspkFolder = "/etc/static/nspk/"
const defaultNspkResponseFileIOS = "nspk_bank_apps_ios.json"
const defaultNspkResponseFileAndroid = "nspk_bank_apps_android.json"

type Cache struct {
	DefaultResponseC2BMembers        nspk.ProxyAppC2BMembers
	DefaultResponseDigitalAssetLinks nspk.DigitalAssetLinks
}

func LoadCache(cache *Cache, logger log.Logger) error {
	nspkFolder, ok := os.LookupEnv("FOLDER_STATIC_NSPK")
	if !ok {
		nspkFolder = defaultStaticNspkFolder
	}
	defaultNspkResponseIOS := filepath.Join(nspkFolder, defaultNspkResponseFileIOS)
	defaultNspkResponseAndroid := filepath.Join(nspkFolder, defaultNspkResponseFileAndroid)

	logger.Info("Loading NSPK response cache file", log.String("path", defaultNspkResponseIOS), log.String("type", "c2bmembers"))
	bytes, err := ioutil.ReadFile(defaultNspkResponseIOS)
	if err != nil {
		logger.Error("Failed to open NSPK response cache file", log.String("path", defaultNspkResponseIOS), log.String("type", "c2bmembers"), log.Error(err))
		return err
	}
	err = json.Unmarshal(bytes, &cache.DefaultResponseC2BMembers)
	if err != nil {
		logger.Error("Failed to parse NSPK response cache file", log.String("path", defaultNspkResponseIOS), log.String("type", "c2bmembers"), log.Error(err))
		return err
	}

	logger.Info("Loading NSPK response cache file", log.String("path", defaultNspkResponseIOS), log.String("type", "assetlinks"))
	bytes, err = ioutil.ReadFile(defaultNspkResponseAndroid)
	if err != nil {
		logger.Error("Failed to open NSPK response cache file", log.String("path", defaultNspkResponseIOS), log.String("type", "assetlinks"), log.Error(err))
		return err
	}
	err = json.Unmarshal(bytes, &cache.DefaultResponseDigitalAssetLinks)
	if err != nil {
		logger.Error("Failed to parse NSPK response cache file", log.String("path", defaultNspkResponseIOS), log.String("type", "assetlinks"), log.Error(err))
		return err
	}
	return nil
}
