package payment

import (
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/logic/models"
	"context"
)

type PaymentService interface {
	InitPayment(ctx context.Context, uid uint64, serviceToken string, email string, token string, turboappID string, credit bool) (models.Payment, error)
	PaymentMethodsDefault(ctx context.Context, uid uint64, serviceToken string, paymentSystemsOptions models.PaymentSystemsOptions) (models.UserPaymentMethods, error)
	PaymentMethods(ctx context.Context, uid uint64, serviceToken string, paymentSystemsOptions models.PaymentSystemsOptions, env models.OrderEnvironment) (models.UserPaymentMethods, error)
	RequestMarkup(ctx context.Context, uid uint64, token string, spasiboAmount string, serviceToken string, env models.OrderEnvironment) error
}
