package provider

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/logic/models"
	"a.yandex-team.ru/mail/payments-sdk-backend/internal/utils/ctxutil"
	"context"
	"errors"
)

func (s *PaymentService) RequestMarkup(ctx context.Context, uid uint64, token string, spasiboAmount string, serviceToken string, env models.OrderEnvironment) (err error) {
	if uid == 0 {
		return errors.New("unauthenticated user")
	}

	if len(serviceToken) == 0 {
		serviceToken = s.config.GetServiceToken(env, s.config.DefaultAcquirer)
	}
	ctx = ctxutil.WithServiceToken(ctx, serviceToken)

	trustClient := s.getTrustClient(env)

	err = trustClient.RequestMarkup(ctx, token, serviceToken, uid, spasiboAmount)
	if err != nil {
		s.logger.Error("Failed to call request_markup", append(ctxutil.GetStoredFields(ctx), log.Error(err))...)
	}
	return
}
